<?PHP
/**
*	patXMLServer_Dom
*	needs domxml extension
*	PHP socket xml server base class
*	Events that can be handled:
*	  * onStart
*	  * onConnect
*	  * onConnectionRefused
*	  * onClose
*	  * onShutdown
*	  * onReceiveRequest
*
*	Methods used to send responses:
*	  * sendResponse
*	  * broadcastResponse
*
*	@version	0.1
*	@author		Stephan Schmidt <schst@php-tools.net>, Gerd Schaufelberger <gerd@php-tools.net>
*	@package	patServer
*/
	class	patXMLServer_Dom extends patServer
{
/**
*	server received data
*	decodes the request
*
*	@access	private
*	@param	integer	$clientId	id of the client that sent the data
*	@param	string	$xml		xml data
*/
	function	onReceiveData( $clientId, $xml )
	{
		//	create dom tree
		$xmldoc		=	xmldoc( trim( $xml ) );
		
		//	get root element (type of request)
		$root			=	$xmldoc->root();
		$requestType	=	$root->node_name();
		
		//	extract request parameters
		$requestParams		=	array();
		foreach( $root->children() as $child )
		{
			if( $child->node_type() != XML_ELEMENT_NODE )
				continue;
	
			$content	=	"";
			foreach( $child->children() as $tmp )
			{
				if( $tmp->node_type() != XML_TEXT_NODE && $tmp->node_type() != XML_CDATA_SECTION_NODE )
					continue;
				$content	.=	$tmp->node_value();
			}
			$requestParams[$child->node_name()]	=	$content;
		}

		if( method_exists( $this, "onReceiveRequest" ) )
			$this->onReceiveRequest( $clientId, $requestType, $requestParams );
	}

/**
*	send a response
*
*	@access	public
*	@param	integer	$clientId	id of the client to that the response should be sent
*	@param	string	$responseType	type of response
*	@param	array	$responseParams	all params
*	@return	boolean	$success
*/
	function	sendResponse( $clientId, $responseType, $responseParams )
	{
		$xml	=	$this->encodeResponse( $responseType, $responseParams );
		$this->sendData( $clientId, $xml );
	}

/**
*	send response to all clients
*
*	@access	public
*	@param	string	$data		data to send
*	@param	array	$exclude	client ids to exclude
*/
	function	broadcastResponse( $responseType, $responseParams, $exclude = array() )
	{
		$xml	=	$this->encodeResponse( $responseType, $responseParams );
		$this->broadcastData( $xml, $exclude );
	}
	
/**
*	encode a request
*
*	@access	public
*	@param	string	$responseType	type of response
*	@param	array	$responseParams	all params
*	@return	string	$xml	encoded reponse
*/
	function	encodeResponse( $responseType, $responseParams )
	{
		if( empty( $responseParams ) )
			return	sprintf( "<%s/>\0", $responseType );

		$xml	=	sprintf( "<%s>", $responseType );
		foreach( $responseParams as $key => $value )
		{
			if( $value == "" )
				$xml	.=	sprintf( "<%s/>", $key );
			else
				$xml	.=	sprintf( "<%s>%s</%s>", $key, $value, $key );
		}
		$xml	.=	sprintf( "</%s>\0", $responseType );

		return	$xml;
	}
}
?>