<?PHP

/**
*	patTelnetChatServer
*	simple example to demonstrate how patServer is used
*
*	@access		public
*	@version	0.1
*	@author		Stephan Schmidt <schst@php-tools.net>
*/
	class	patTelnetChatServer extends patServer
{
	var	$users	=	array();

/**
*	server is started
*
*	@access	private
*/
	function	onStart()
	{
		$this->sendDebugMessage( "patChatServer started." );
	}

/**
*	data is received
*
*	@access	private
*	@param	integer	$clientId	id of client that sent the data
*	@param	string	$data		data that was sent
*/
	function	onReceiveData( $clientId, $data )
	{
		//	trim whitespace
		$data	=	trim( $data );

		//	check, whether command was sent
		if( strstr( $data, "*" ) )
		{
			list( $command, $params )	=	explode( " ", substr( $data, 1 ), 2 );
			$this->handleCommand( $clientId, $command, $params );
		}
		//	no command => broadcast
		else

		//change for Flash Program --Keith
		//			$this->broadcastData( $this->users[$clientId]["nick"].": $data\n" );
		$this->broadcastData("$data\n" );
	}

/**
*	User listing
*
*	@access	private
*	--Keith sends a list of all current users to the ChatClient
*/
	function	usersNow()
	{
		$userInfo = "<user>";
		for( $i = 0; $i < count( $this->users ); $i++ )
		{
			$userInfo .= $this->users[$i]["nick"] . "\n";
		}
		$userInfo .= "</user>";
		$this->broadcastData($userInfo);
	}
	
/**
*	connection closed
*
*	@access	private
*	@param	integer	$clientId	id of the client that closed connection
*/
	function	onClose( $clientId )
	{
		$this->sendData( $clientId, "patServer says bye bye...\n" );
		unset( $this->users[$clientId] );
		$this->usersNow();
	}

/**
*	connection established
*
*	@access	private
*	@param	integer	$clientId	id of the client that established connection
*/
	function	onConnect( $clientId )
	{
		global $gameServer;
		$this->users[$clientId]	=	array(
												"nick"		=>	"user" . $clientId
											);
		$welcomeString				=	"Welcome to Yumichat.\n".
										"Your handle is ".$this->users[$clientId]["nick"]."\n";
		
//		$this->sendData( $clientId, $welcomeString );
	}

/**
*	server is shut down
*
*	@access	private
*/
	function	onShutdown()
	{
		$this->broadcastData( "Oops! Seems that someone pulled the plug...\n" );
	}

/**
*	connection was refused (too many clients)
*
*	@access	private
*	@param	integer	$clientId	id of the client that wasn't allowed to connect
*/
	function	onConnectionRefused( $clientId )
	{
		$this->sendData( $clientId, "Sorry, too many connections. Try again later.\n" );
	}

/**
*	handle a command
*
*	@access	private
*	@param	integer	$clientId	id of the client that sent the command
*	@param	string	$command	name of the command
*	@param	string	$params		list of all params
*/

//--Keith

	function	handleCommand( $clientId, $command, $params )
	{
		switch( strtolower( $command ) )
		{
			//	shutdown server
			case	"shutdown":
				$this->shutdown();
				break;
			//	client wants to quit
			case	"quit":
				$this->closeConnection( $clientId );
				break;
			//	change nick
			case	"nick":
				$this->users[$clientId]["nick"]	=	$params;
				$welcomeString2		=	"Welcome to Yumichat.\n".
										"Your handle is ".$this->users[$clientId]["nick"]."\n";
				$this->sendData( $clientId, $welcomeString2);
				$this->usersNow();
				break;
			//	whois
			case	"whois":
				$destId		=	$this->getClientIdByNick( $params );
				$info		=	$this->getClientInfo( $destId );
				$infoString	=	"User $params\n".
								"Host: ".$info["host"]."\n".
								"Logged in since: ".date( "Y-m-d H:i:s", $info["connectOn"] )."\n";
				$this->sendData( $clientId, $infoString );
				break;
			//	msg
			case	"msg":
				list( $nick, $msg )		=	explode( " ", $params, 2 );
				$destId		=	$this->getClientIdByNick( $nick );
				$this->sendData( $destId, $this->users[$clientId]["nick"]." > ".$msg."\n" );
				break;
			//	display information
			case	"info":
				$info		=	$this->getClientInfo( $clientId );
				$infoString	=	"patTelnetChatServer 0.1\n".
								"Currently serving ".$this->getClients()." clients\n".
								"Your Host: ".$info["host"]."\n".
								"Logged in since: ".date( "Y-m-d H:i:s", $info["connectOn"] )."\n";
				$this->sendData( $clientId, $infoString );
				break;
			//  The write Command for writing User Information
			case	"write":
				$info		=	$this->getClientInfo( $clientId );
				$filename = $this->users[$clientId]["nick"].".txt";
				$somecontent = $params;

				if (!$handle = fopen($filename, 'w')) {
					echo "Cannot open file ($filename)";
					 exit;
				}

				// Write $somecontent to our opened file.
				if (fwrite($handle, $somecontent) === FALSE) {
				   echo "Cannot write to file ($filename)";
				   exit;
				}
				 
				echo "Success, wrote ($somecontent) to file ($filename)";
				fclose($handle);
				break;
			
			//	unknown command
			default:
				$this->sendData( $clientId, "Unknown command ".$command.".\n" );
				break;
		}
	}

/**
*	get id of file descriptor by nickname
*
*	@access	public
*	@param	string	$nick		username
*	@return	integer	$clientId	id of the file descriptor for the socket
*/
	
	function	getClientIdByNick( $nick )
	{
		for( $i = 0; $i < count( $this->users ); $i++ )
		{
			if( $this->users[$i]["nick"] == $nick )
				return	$i;
		}
		return	-1;
	}
}
?>